#|_______________________________________________
 |
 | vismenu4.lsp 
 | WINDOW, DESKTOP, and WORKMAP POPUP menus
 | Copyright (c) 1991-2002 by Forrest W. Young
 |_______________________________________________
 |#


#|_________________________________________________________________
 |
 | WINDOW MENU (REVISED FWY SEPTEMBER 2001)
 |_________________________________________________________________
 |#


(setf *desktop-window-menu* (send menu-proto :new "Window"))

;--- DESKTOP WINDOW

(defun desktop-window () 
  (show-vista)
  (send *desktop-container* :front-window))

(setf *show-desktop-window-item*
      (send menu-item-proto :new "DeskTop Window"
            :action #'(lambda () (desktop-window))))

;--- VIVA WINDOW


(setf *show-viva-window-item*
      (send menu-item-proto :new "ViVa Window"
            :action #'(lambda () (viva-window))))


;--- DATASHEET WINDOW

(defun current-datasheet ()
"Args: None
Displays the most recently activated datasheet, or, if none activated, the datasheet for the most recently activated data object."
  (cond
    ((and (not *current-data*) (not *current-datasheet*))
     (one-button-dialog (format nil "There is no data object nor datasheet.") :first-button "Sorry!" :title "No Way!!"))
    ((not *current-datasheet*) (edit-datasheet))
    ((send *current-datasheet* :show-window))))

(setf *show-datasheet-window-item*
      (send expert-menu-item-proto :new "Current DataSheet" 
            :enabled nil
            :action #'(lambda () (current-datasheet))))


;----SPREADPLOT WINDOW

(setf *current-spreadplot* nil)

(defun current-spreadplot () 
"Args: None
Displays a new spreadplot for the most recently active data or model object."
  (cond
    ((not *current-object*)
     (one-button-dialog "There is no statistical object to visualize" :first-button "Oh Well, I guess thats the way it goes!" :title "You Dummy"))
    ((equal *current-object* *current-model*) (visualize-model :dialog t))
    (t (visualize-data :dialog t))))
    
 
(setf *show-spreadplot-window-item* 
      (send menu-item-proto :new "Current SpreadPlot"
            :enabled nil
            :action 'current-spreadplot))


;----REPORT WINDOW

;(setcd nil)
(defun current-report () 
"Args: None
Displays the report for the most recently active data or model object."
   (cond
     ((not *current-object*)
      (one-button-dialog "There is no statistical object to report" :first-button "Oh Well, I guess thats the way it goes!" :title "You Dummy"))
     ((equal *current-object* *current-model*) (report-model))
     (t (setcd *current-data*) (summarize-data)))) 



(setf *show-report-window-item* 
       (send menu-item-proto :new "Current Report" :enabled nil
             :action 'current-report))

(defun initialize-desktop-window-menu (&optional value)
	(mapcar #'(lambda (w) 
              (send w :enabled value))
	(list *show-report-window-item*
	*show-spreadplot-window-item* 
	*show-datasheet-window-item*)))


;--- XLISPSTAT WINDOW


(setf *main-menubar* t)

#|fwy moved to defun0.lsp 09-22-02
(defun xlispstat-window (&key (viva nil))
  (hidemainwindow)
  (defaultmainwindow); fwy added following clause 09-23-02
  (when (and (boundp '*show-xlispstat-window-item*)
             (not (not *show-xlispstat-window-item*)))
	(send *show-xlispstat-window-item* :mark t))
  (when viva (print-viva-listener-help));fwy added 09-22-02
  (when (and (not *main-menubar*) *devel-mode*) (main-menubar))
  )
|#

(setf *show-xlispstat-window-item*
      (send expert-menu-item-proto :new "XLispStat Window"
            :action #'(lambda () (xlispstat-window))))

(setf *show-floating-menubar-item*
      (send expert-menu-item-proto :new "Floating MenuBar"
            :action #'(lambda () (floating-menubar))))

(setf *show-help-panel-item*
      (send expert-menu-item-proto :new "Help Panel"
            :action #'(lambda () (help-topics))))


;used by cloaner for popups
(setf *window-items*
      (list *show-desktop-window-item* 
            *show-xlispstat-window-item*
            (send dash-item-proto :new)
            *show-datasheet-window-item* 
            *show-spreadplot-window-item* 
            *show-report-window-item*
            (send dash-item-proto :new)
            ))


;used by desktop
(setf *desktop-window-items*
      (list *show-desktop-window-item* 
            *show-xlispstat-window-item*
            *show-viva-window-item*
            (send dash-item-proto :new)
            *show-datasheet-window-item* 
            *show-spreadplot-window-item* 
            *show-report-window-item*
            (send dash-item-proto :new)
            ))



; CONSTRUCT THE WINDOW MENU

(apply #'send *desktop-window-menu* :delete-items 
       (send *desktop-window-menu* :items))

(apply #'send *desktop-window-menu* :append-items *desktop-window-items*)

#|______________________________________________________
 | 
 | DESKTOP MENU
 |_____________________________________________________
 |#

;----MAXIMIZE WORKMAP    0
;   (maximize datasheet  1)
;----MAXIMIZE LISTENER   2
;----RESTORE LAYOUT      3  
;note that these three items and also the no-longer used maximize-datasheet
;item are all performed by the remake-desktop-menu-items function

(setf *workmap-maximized?* nil)
(setf *listener-maximized* nil)

(defun remake-desktop-menu-items (i p &optional 
                                    (n *num-listener-lines*) (restore-selector n) )
"i=0,1,2 or 3 for maxworkmap,maxdatasheet,maxlistener,restore"

  ;(SETF P 1) ;ALWAYS FORCE WORKMAP TO BE ENTIRE AREA,
  ;           ;THIS PERMANENTLY HIDES THE DESKTOP DATASHEET
  (unless (< -1 i 4) 
         ; (one-button-dialog "FIXING ILLEGAL VALUE IN REMAKE-DESKTOP")
          (setf i 3))

  (unless *desktop-sheet* 
     (enable-container *desktop-container*)
     (setf *desktop-sheet* (send graph-window-proto :new  
                          :location '(2000 2000) :size '(2000 2000))))

  (send *desktop-datasheet* :top-most nil) ;FWY added these two lines Oct 2001
  (send *desktop-datasheet* :bottom-most t);to permanently hide datasheet
  
  (let* ((items  (list *max-workmap-item* *max-datasheet-item* 
                       *max-listener-item* *restore-layout-item* ))
         (overlay (first (send *desktop-datasheet* :overlays)))
         (item))
    (flet ((switch-items (not-this-item) 
                         (mapcar #'(lambda (item) 
                                     (if (equal item not-this-item)
                                         (send item :enabled nil)
                                         (send item :enabled t)))
                                 items))
           )
      (setf *desktop-layout-state* i)
      (setf item (select items i))
      (switch-items item)
      (send *vista* :workmap-proportion p)
      (if restore-selector (send *show/hide-selector-item* :enabled t))
      (unless (= i 2)
              (send *desktop-listener-item* :enabled t)
              (send *desktop-container* :make-desktop-container-resize)
              (setf *num-listener-lines* n)
              (setf *maximized-listener?* nil)
              )

      (case i
        (0 ;max workmap
           (send *workmap* :top-most t)
           (send *varobs-obj* :bottom-most t)
           (send *max-workmap-item* :title "Reduce WorkMap")
           (send *show/hide-selector-item* :enabled t)
           (send overlay :max-state t)
           (send overlay :setup-redraw)
           (send overlay :draw-button nil 3)
           (setf *workmap-maximized?* t)
           (send *listener* :maximized? nil)
           (send *desktop-sheet* :bottom-most t)
           (send *desktop-sheet* :top-most nil))
        (1 ;max datasheet
           )
        (2 ;max listener
           (send *desktop-container* :make-desktop-container-resize-for-maximized-listener)
           (send *max-listener-item* :title "Reduce Listener")
           (send *desktop-datasheet* :bottom-most t)
           (send *show/hide-selector-item* :enabled nil)
           (send *workmap* :bottom-most t)
           (send *varobs-obj* :bottom-most t)
           (send *listener* :maximize)
           (setf *maximized-listener?* t)
           (setf *workmap-maximized?* nil)
           (send *listener* :maximized? t)
           (send *desktop-sheet* :bottom-most t)
           (send *desktop-sheet* :top-most nil))
        (3 ;restore
           (setf *full-screen-desktop* nil)
           (setf *exploded-desktop* nil)
           ;fwy added next line july 2002 - removed oct 2002
           ;(setf *num-listener-lines* *default-num-listener-lines*)
           (send *desktop-sheet* :bottom-most nil)
           (send *desktop-sheet* :top-most t)
           (send *desktop-datasheet* :top-most nil)
           (send *desktop-datasheet* :bottom-most t)
           (send *max-workmap-item* :mark nil)
           (send *max-listener-item* :mark nil)
           (send *show/hide-selector-item* :enabled t)
           (send *workmap* :top-most t)
           (send *varobs-obj* :top-most t)
           (send overlay :max-state nil)
           (send overlay :setup-redraw)
           (send overlay :draw-button nil 3)
           (send *desktop-datasheet* :max-restore nil p)
           (setf *workmap-maximized?* nil)
           (send *listener* :maximized? nil)
           (send *desktop-sheet* :bottom-most t)
           (send *desktop-sheet* :top-most nil)
           ))
      (unless (= i 2)
              (send *vista* :workmap-proportion p)
              (send *vista* :refresh-desktop :first-time nil :resize nil)
              )
      item)))

(defun maximize-datasheet () (remake-desktop-menu-items 1 0))

(defun maximize-workmap ()
  (remake-desktop-menu-items 0 1 0 NIL)
  (setf *workmap-maximized?* t)
  (send *listener* :maximized? nil)
  (send *maximize-listener-item* :title "Maximize Listener")
  (send *maximize-workmap-item*  :title "Restore DeskTop"))

(defun maximize-listener ()
  (remake-desktop-menu-items 2 1)
  (setf *workmap-maximized?* nil)
  (send *listener* :maximized? t)
  (send *maximize-listener-item* :title "Restore DeskTop")
  (send *maximize-workmap-item*  :title "Maximize WorkMap"))  

(defun restore-desktop ()
  (when (send *workmap* :popped-out?) 
        (send *desktop-datasheet* :pop-out nil))
  (remake-desktop-menu-items 3 1 *num-listener-lines* NIL)
  (setf *workmap-maximized?* nil)
  (send *listener* :maximized? nil)
  (send *maximize-listener-item* :title "Maximize Listener")
  (send *maximize-workmap-item*  :title "Maximize WorkMap")
  (send *maximize-listener-item* :enabled t)
  (send *maximize-workmap-item*  :enabled t)
  (send *restore-desktop-item*   :enabled nil)
  (send *workmap* :pop-out nil)
  (send *selector* :pop-out nil)
  )

(defun restore-layout () (restore-desktop))

;the next three items are used by the menus

(setf *maximize-workmap-item*
      (send expert-menu-item-proto :new "Maximize WorkMap"
            :action #'(lambda () (if (equal "Maximize WorkMap" (send self :title))
                                     (maximize-workmap)(restore-desktop) ))))

(setf *maximize-listener-item*
      (send expert-menu-item-proto :new "Maximize Listener"
            :action #'(lambda () (if (equal "Maximize Listener" (send self :title))
                                     (maximize-listener)(restore-desktop) ))))

(setf *restore-desktop-item*
      (send expert-menu-item-proto :new "Restore DeskTop"
            :action #'(lambda () (restore-desktop))))


;SHOW-HIDE SELECTOR PANE

(defun show-selector ()
  (send *show/hide-selector-item* :title "Hide Selector")
  (send *show/hide-popup-selector-item* :title "Hide Selector")
  (send *vista* :show-varobs t)
  (send *desktop-container* :resize))

(defun hide-selector ()
  (send *show/hide-selector-item* :title "Show Selector")
  (send *show/hide-popup-selector-item* :title "Show Selector")
  (send *vista* :show-varobs nil)
  (send *desktop-container* :resize))

(defun show/hide-selector ()
  (if (send *vista* :show-varobs) (hide-selector) (show-selector)))

(setf *show/hide-selector-item* 
      (send expert-menu-item-proto  :new "Hide Selector" :action #'show/hide-selector))

(setf *show/hide-popup-selector-item*
      (send expert-menu-item-proto  :new "Hide Selector" :action #'show/hide-selector))

; SHOW-HIDE LISTENER

(defun show-listener ()
  (setf *num-listener-lines* *default-num-listener-lines*)
  (send *desktop-container* :resize))

(defun hide-listener ()
  (setf *num-listener-lines* 0)
  (send *desktop-container* :resize))


(defun show/hide-desktop-listener ()
  (cond 
    ((equal "Hide Listener"
            (send *desktop-listener-item* :title))
     (hide-listener)
     (send *desktop-listener-item* :title "Show Listener"))
    (t
     (show-listener)
     (send *desktop-listener-item* :title "Hide Listener"))))


(setf *desktop-listener-item*
      (send expert-menu-item-proto :new "Hide Listener"
            :action #'(lambda () 
			(show/hide-desktop-listener))))


; FULL-SCREEN-DESKTOP

(setf *full-screen-menu-item* 
      (send expert-menu-item-proto  :new "Full Screen" 
            :action #'(lambda () (full-screen-desktop))
            :mark *full-screen-desktop*))

;; INITIAL-DESKTOP

(defun initial-desktop ()
    (send *desktop-container* :frame-location 15 15)
    (apply #'send *desktop-container* :frame-size (- (effective-screen-size) '(30 30))))

(setf command-menu-initial-desktop-item
      (send expert-menu-item-proto :new "Initial DeskTop"
            :action #'(lambda () (initial-desktop))))


;; DEFAULT DESKTOP

 (defun default-desktop (&optional seven-values)
   (let* ((dv (if seven-values seven-values (default-seven-values))))
     (when *full-screen-desktop* (full-screen-desktop))
     (when *exploded-desktop* (implode-desktop))
     (apply #'set-seven-values dv)
     (use-seven-values)
     (show-selector)
     (send *show/hide-selector-item* :enabled t)
     (send *desktop-listener-item* :enabled nil)
     (send *max-desk-item* :enabled t)
     (send *restore-desktop-item* :enabled nil)
     (setf *num-listener-lines* *default-num-listener-lines*)
     (when (send *workmap* :pop-out) (send *workmap* :pop-out nil))
     (when (send *selector* :pop-out) (send *selector* :pop-out nil))
     (send *desktop-container* :size)))

;; MINI DESKTOP

(defun mini-desktop ()
  (default-desktop (mini-seven-values)))

(setf *mini-desktop-item*
      (send expert-menu-item-proto :new "Mini DeskTop"
            :action #'mini-desktop))

(defun hide-desktop () (hide-vista))

(setf *default-desktop-menu-item*
      (send expert-menu-item-proto :new "Default DeskTop"
            :action #'default-desktop))


(setf command-menu-hide-desktop-item
      (send expert-menu-item-proto :new "Hide DeskTop"
            :action #'(lambda () (hide-desktop))))


 (setf *set-desktop-layout-item*
       (send expert-menu-item-proto :new "DeskTop Options ..."
             :action #'(lambda () (desktop-options))))

(defun desktop-options ()
  (desktop-layout))

(defun toolbar-buttons ()
  (send *workmap* :edit-toolbar))

(setf command-menu-edit-toolbar-item
      (send expert-menu-item-proto :new "ToolBar Buttons ..."
            :action 'toolbar-buttons))

(defun workmap-icons () (send *workmap* :workmap-options))

(setf command-menu-options-item
      (send expert-menu-item-proto :new "WorkMap Icons ..."
            :action 'desktop-options))

(defun floating-menubar () (menubar))

(setf *explode-desktop-menu-item*
      (send expert-menu-item-proto :new "Explode DeskTop"  :enabled t
            :action 'explode-deskTop))

(defun colors () (change-colors))
(defun desktop-colors () (change-colors))

(setf command-menu-colors-item
      (send expert-menu-item-proto :new "DeskTop Colors ..."
            :action 'desktop-colors))

(setf *desktop-desktop-menu* (send menu-proto :new "DeskTop"))
 

(setf desktop-menustrip-item
      (send expert-menu-item-proto :new "MenuStrip"
            :action 'menustrip))

(setf desktop-menubar-item
      (send expert-menu-item-proto :new "MenuBar"
            :action 'menubar))

(setf desktop-shazam-item
      (send expert-menu-item-proto :new "Shazam"
            :action 'shazam))

(setf *desktop-desktop-menu-items*
      (list
       *maximize-workmap-item*
       *maximize-listener-item*
       *show/hide-selector-item*
       (send dash-item-proto :new)
       *full-screen-menu-item*
       *explode-desktop-menu-item*
       command-menu-hide-desktop-item
       (send dash-item-proto :new)
       *default-desktop-menu-item*
       *mini-desktop-item*
       (send dash-item-proto :new)
       *set-desktop-layout-item*
       command-menu-edit-toolbar-item
       command-menu-colors-item
       ))


(apply #'send *desktop-desktop-menu* :append-items
      *desktop-desktop-menu-items*)

       


#|_______________________
 |
 | POPUP MENUS
 |_______________________
 |#


 
(defun create-popup-menus ()
  (container :in nil :localmenu t :title "Menu Bar" :size '(250 18) :show nil)
  (setf *trans-popup-menu* (cloan-menu *trans-menu*))
  (setf *tools-popup-menu* (cloan-menu *tools-menu*))
  (setf *model-popup-menu* (cloan-menu *model-menu*))
  (setf *command-popup-menu* (cloan-menu *command-menu*))
  (setf *datasheet-popup-menu* (send datasheet-proto :define-datasheet-menu))
  (setf *dataplots-popup-menu* (send menu-proto :new "Plots"))
  (apply #'send *dataplots-popup-menu* :append-items 
         (items-cloaner (send *plots-menu* :items)))
  (setf *datavis-popup-menu* (send menu-proto :new "Views"))
  (apply #'send *datavis-popup-menu* :append-items 
         (combine
          (items-cloaner (send *plots-menu* :items))
          (send dash-item-proto :new)
          (items-cloaner (send *views-menu* :items))))

  (let* ((FILE-ITEMS (menu-items-cloaner *vista-file-menu*)) ;!FILE
         (desktop-file-items (items-cloaner (select FILE-ITEMS '(0 1 2 4)))) ;!FILE
         (delete-item (items-cloaner (select (send *edit-menu* :items) 0))) 
         (popup-maximize-workmap-item (send expert-menu-item-proto :new "Maximize WorkMap"
            :action #'(lambda () (if (equal "Maximize WorkMap" (send self :title))
                                  (maximize-workmap)(restore-desktop)))))
         (popup-maximize-listener-item 
          (send expert-menu-item-proto :new "Maximize Listener" :action #'maximize-listener))
         
         (data-items (menu-items-cloaner *data-menu*))
         (analyze-items (menu-items-cloaner *tools-menu*))
         (selector-items (items-cloaner *selector-items*))
         (config-items )
         (window-items (combine (send dash-item-proto :new) (items-cloaner *window-items*)))
         (print-items 
          (combine (send dash-item-proto :new)
                   (send menu-item-proto :new "&Print This Pane..." 
                         :action #'msw-print)
                   (send menu-item-proto :new "Print Entire Window" 
                         :action #'msw-container-print)
                   ;(send menu-item-proto :new "Page Set&up..." ;fwy july 2002
                   ;      :action #'msw-pagesetup)
                   ))
         (exit-items (list (send dash-item-proto :new) (first (last FILE-ITEMS)))) 
         (desktop-option-items (list *set-desktop-layout-item* command-menu-colors-item))
         (desktop-items 
          (items-cloaner (combine desktop-option-items print-items exit-items)))
         (toolbar-items 
          (items-cloaner (combine command-menu-edit-toolbar-item print-items exit-items)))
         )
    (setf *data-icon-cap-menu* (send menu-proto :new "Print Data"))
    (apply #'send *data-icon-cap-menu* 
           :append-items (items-cloaner *data-icon-cap-items*))
    (apply #'send *model-popup-menu* 
           :append-items (items-cloaner (select FILE-ITEMS (list 8))))
    
    (setf *desktop-popup-menu* (send menu-proto :new "DeskTop"))
    (apply #'send *desktop-popup-menu* :append-items
           (combine desktop-file-items 
                    (send dash-item-proto :new)
                    popup-maximize-workmap-item 
                    popup-maximize-listener-item
                    *show/hide-popup-selector-item*
                    ;workmap-window-items 
                    (send dash-item-proto :new)
                    (items-cloaner desktop-items) ))
    (send (select (send *desktop-popup-menu* :items) 2) :enabled t)
    
    (setf *data-popup-menu* (send menu-proto :new "DataPopUp"))
    (apply #'send *data-popup-menu* :append-items
           (combine (items-cloaner *data-icon-items*)
                    (send dash-item-proto :new)            ;!
                    (items-cloaner 
                     (list save-data-menu-item 
                           export-data-file-menu-item 
                           ))))
    
    (send (select *data-icon-cap-items* 1) :enabled t)
    (setf *toolbar-popup-menu* (send menu-proto :new "ToolbarPopup"))
    (apply #'send *toolbar-popup-menu* :append-items toolbar-items)
    
    (setf *selector-popup-menu* (send menu-proto :new "SelectorPopup"))
    (apply #'send *selector-popup-menu* :append-items
           (combine (send link-item-proto :new self)
                    (send dash-item-proto :new)
                   ; selector-items
                    (items-cloaner desktop-items)))
    
    (setf *dash-icon-popup-menu* (send menu-proto :new "DataSheetPopup"))
    (send *dash-icon-popup-menu* :append-items
          (send expert-menu-item-proto :new "DataSheet Help"
                :action #'(lambda () (datasheet-help)))
          (send expert-menu-item-proto :new "About These Data" ;fwy changed 09-24-02
                :action #'(lambda () 
                            (setcd (first (send @ :dob-parents)))
                            (about-these-data)
                            (setcds $$$)))
          (send dash-item-proto :new)
          (send expert-menu-item-proto :new "Show DataSheet"
                :action #'(lambda () (show-datasheet)))
          (send dash-item-proto :new)
          (send expert-menu-item-proto :new "Create Data Object" ;fwy changed 09-24-02
                :action #'(lambda () (create-data-object)))
          (send expert-menu-item-proto :new "Save Data As ..."
                :action #'(lambda () (save-data-as)))
          (send dash-item-proto :new)
          (send expert-menu-item-proto :new "Delete DataSheet Object"
                :action #'(lambda () (delete-datasheet-object)))
          )
    (setf *data-trans-popup-menu* (cloan-menu *trans-menu*))
    (setf *data-analy-popup-menu*  (cloan-menu *tools-menu*))
    (setf *anal-popup-menu* *data-analy-popup-menu*)
    (setf *trans-popup-menu* *data-trans-popup-menu*)

    
    (let ((sum (send expert-menu-item-proto :new "Summarize Data"
                :action #'(lambda () (summarize-data))))
          (lst (send expert-menu-item-proto :new "List Data"
                :action #'(lambda () (list-data))))
          (mom (send expert-menu-item-proto :new "Show Moments"
                :action #'(lambda () (show-moments))))
          (qar (send expert-menu-item-proto :new "Show Quartiles and Ranges"
                :action #'(lambda () (show-quartiles-and-ranges))))
          (cor (send expert-menu-item-proto :new "Show Correlations and Covariances"
                :action #'(lambda () (show-correlations-and-covariances))))
          (dis (send expert-menu-item-proto :new "Show Distances"
                :action #'(lambda () (show-distances))))
          (frq (send expert-menu-item-proto :new "Show CrossTabulation"
                :action #'(lambda () (show-crosstabulation))))
          )
      (setf *stats-popup-menu*   (send menu-proto :new "stats-Popup"))
      (send *stats-popup-menu*   :append-items
            sum lst 
            (send dash-item-proto :new)
            mom qar
            (send dash-item-proto :new)
            cor dis
            (send dash-item-proto :new)
            frq)
      (defmeth *stats-popup-menu* :popup-menu (x y w)
        (let ((numeric0? (> (length (send $ :active-variables '(numeric))) 0))
              (numeric1? (> (length (send $ :active-variables '(numeric))) 1))
              (cat? (> (length (send $ :active-variables '(category))) 1))
              (freq? (send $ :freq-data?)))
          (mapcar #'(lambda (item) (send item :enabled numeric0?))
                  (list mom qar dis))
          (mapcar #'(lambda (item) (send item :enabled numeric1?))
                  (list cor))
          (send frq :enabled (or cat? freq?))
          (call-next-method x y w)))
      (send *stats-popup-menu*   :install))

    (send *datavis-popup-menu* :install)
    (send *desktop-popup-menu* :install)
    (send *command-popup-menu* :install)
    (send *data-popup-menu*    :install)
    (send *trans-popup-menu*   :install)
    (send *anal-popup-menu*    :install)
    (send *data-icon-cap-menu* :install)
    (send *dash-icon-popup-menu* :install)
    (send *trans-popup-menu*   :install)
    (send *tools-popup-menu*   :install)
    (send *toolbar-popup-menu* :install)
    (send *model-popup-menu*   :install)
    (send *selector-popup-menu* :install)
    ))
